import ml_collections


def get_config():
    config = ml_collections.ConfigDict(type_safe=False)

    config.actor_lr = 3e-4
    config.value_lr = 3e-4
    config.critic_lr = 3e-4

    config.hidden_dims = (256, 256)

    config.discount = 0.99

    config.expectile = 0.9  # The actual tau for expectiles.
    config.temperature = 10.0  # 10.0
    config.dropout_rate = 0.0
    config.layernorm = True
    config.value_dropout_rate = 0.5

    config.tau = 0.005  # For soft target updates.
    config.opt_decay_schedule = None  # Don't decay optimizer lr

    return config
